/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.fw.ntfy.TextBasedEvent;
import com.ibm.hwmca.fw.ntfy.TextField;
import com.ibm.hwmca.fw.ntfy.TextFilter;
import java.io.Serializable;
import java.util.EventObject;
import java.util.StringTokenizer;

public class NumericCollectionFilter
extends TextFilter
implements Serializable {
    static final long serialVersionUID = -4100738304551610717L;
    public static final int[] LEGAL_OPS = new int[]{100, 101, 1000, 1001};
    private int[] _operands;

    NumericCollectionFilter() {
    }

    public NumericCollectionFilter(String name, int operation, String operand, TextField field) {
        super(name, operation, operand, field);
    }

    public boolean pass(EventObject event) {
        if (!super.pass(event)) {
            return false;
        }
        boolean result = false;
        try {
            int fieldValue = Integer.parseInt(this.getFieldData(((TextBasedEvent)event).getText()));
            switch (this._operation) {
                case 100: {
                    result = this._operands[0] < fieldValue && fieldValue < this._operands[1];
                    break;
                }
                case 101: {
                    result = this._operands[0] > fieldValue || fieldValue > this._operands[1];
                    break;
                }
                case 1000: {
                    result = this.opIn(fieldValue);
                    break;
                }
                case 1001: {
                    result = !this.opIn(fieldValue);
                }
            }
        }
        catch (Exception e) {}
        return result;
    }

    private boolean opIn(int fieldValue) {
        int i = 0;
        while (i < this._operands.length) {
            if (fieldValue == this._operands[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean validateData(int op, String operand) {
        boolean result;
        block2: {
            result = false;
            if (!TextFilter.isLegalOp(op, LEGAL_OPS)) break block2;
            try {
                this._operands = this.parseOperand(operand);
                result = TextFilter.isTertiaryOp(op) && this._operands.length == 2 || TextFilter.isMultiOp(op);
            }
            catch (Exception e) {}
        }
        return result;
    }

    private int[] parseOperand(String operand) {
        StringTokenizer tokens = new StringTokenizer(operand, operand.substring(0, 1));
        int[] operands = new int[tokens.countTokens()];
        int i = 0;
        while (i < operands.length) {
            operands[i] = Integer.parseInt(tokens.nextToken());
            ++i;
        }
        return operands;
    }
}

